
class DanishRevenge expands Mutator config;

var pawn killers[32], player[32];
var config int  iRevengeBonus;

function listPlayers()	//assigns each pawn a unique ID
{
	local Pawn P;
	local int pnum;
	pnum = 0;
	for(P = Level.Pawnlist; P != None; P = P.Nextpawn)
	{
		player[pnum] = P;	//.playerreplicationinfo.playername;
		pnum++;
	}
}

function ModifyPlayer(Pawn Other)
{
	listPlayers();	// if new player enters game, when that player spawns re-setup the pawn IDs
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local int i, j;
	local Pawn P;
	if(Other != Killer)	// Not suicide
	{
		for(j = 0; j < 32; j++)
		{
			if(player[j] == Other)	// if it's the victim
			{
				for(i = 0; i < 32; i++)
				{
					if(player[i] == Killer)
					{
						killers[j] = Killer;	// store his killer
					}
				}
			}
			else if(player[j] == Killer)	// if it's the killer
			{
				if (killers[j] == Other)	// and he killed his last killer
				{
					Killer.PlayerReplicationInfo.Score += iRevengeBonus;	// award bonus
					for ( P=Level.PawnList; P!=None; P=P.NextPawn )
						if ( P.IsA('TournamentPlayer') )
							P.ReceiveLocalizedMessage( class'DanishRevengeMessage', 0, Killer.PlayerReplicationInfo, Other.PlayerReplicationInfo);
				}
				killers[j] = None;	// set his last killer to none (only one chance for revenge: the very next kill...)
			}
		}
	}
	if ( NextMutator != None )
	{
		NextMutator.ScoreKill(killer, other);
	}
}



